(function ($) {
    "use strict";

    window.tmPk = {
        m: function (e) {
            tmPk.d();
            tmPk.methods();
        },
        d: function (e) {
            (this._window = $(window)), (this._document = $(document)), (this._body = $("body")), (this._html = $("html"));
        },
        methods: function (e) {
            tmPk.shapeMove();
            tmPk.serviceWidget();
            tmPk.wowActive();
            tmPk.stickyHeader();
            tmPk.smoothScroll();
            tmPk.menuCurrentLink();
            tmPk.rollingText();
            tmPk.radialProgress();
            tmPk.fonklsAnimation();
            tmPk.onePageNav();
            tmPk.mobileMenuActive();
            tmPk.adjustPageBottomPadding();
            tmPk.stickyToTop();
            tmPk.tmpcustomAnimation();
            tmPk.popupMobileMenu();
            tmPk.preloaderWithBannerActivation();
            tmPk.tmpTiltAnimation();
            tmPk.tmpHover();
            tmPk.titleSplit_2();
            tmPk.lineAnimation();
            tmPk.tmpgradientAnimation();
            tmPk._clickDoc();
            tmPk.initSwiper();
            tmPk.initTooltips();
            tmPk.stickyFaqObserver();
            tmPk.marqueeAnimation();
            tmPk.youtubePopup();
            tmPk._window.on("resize", tmPk.adjustPageBottomPadding);
        },
        shapeMove: function () {
            $('.shape-move').mousemove(function (e) {

                var wx = $(window).width();
                var wy = $(window).height();

                var x = e.pageX - this.offsetLeft;
                var y = e.pageY - this.offsetTop;

                var newx = x - wx / 2;
                var newy = y - wy / 2;

                $('.shape-image .shape').each(function () {
                    var speed = $(this).attr('data-speed');
                    if ($(this).attr('data-revert')) speed *= -1;
                    TweenMax.to($(this), 1, {x: (1 - newx * speed), y: (1 - newy * speed)});

                });

            });
        },
        tmpgradientAnimation: function name(params) {
            var e = document.querySelectorAll(".tmp-gradient-wrapper"),
                t = document.querySelectorAll(".tmp-gradient-animation");
            gsap.to(e, {
                scale: 0.6, repeat: -1, duration: 3, yoyo: !0, ease: Linear.easeNone
            }).play(), gsap.to(t, {repeat: -1, duration: 3, rotation: 360, ease: Linear.easeNone}).play();
        },
        tmpTiltAnimation: function () {
            var tiltActive = document.getElementsByClassName('paralax-image');
            if (tiltActive.length) {
                $('.paralax-image').tilt({
                    maxTilt: 12,
                    speed: 1000,
                    easing: 'cubic-bezier(.03,.98,.52,.99)',
                    transition: false,
                    perspective: 1000,
                    scale: 1
                });
            }
        },
        tmpHover: function () {
            function handleMouseEnter(containerSelector, itemSelector) {
                $(containerSelector).on('mouseenter', itemSelector, function () {
                    var self = this;
                    $(self).removeClass('tmp-control');
                    setTimeout(function () {
                        $(containerSelector + ' .active').removeClass('active').addClass('tmp-control');
                        $(self).removeClass('tmp-control').addClass('active');
                    }, 0);
                });
            }

            // Apply the function to both elements
            handleMouseEnter('.animation-action-1', '.single-animation');
            handleMouseEnter('.animation-action-2', '.single-animation');
            handleMouseEnter('.animation-action-3', '.single-animation');
            handleMouseEnter('.animation-action-4', '.single-animation');
            handleMouseEnter('.animation-action-5', '.single-animation');
            handleMouseEnter('.animation-action-6', '.single-animation');
        },


        _clickDoc: function (e) {
            var inputblur, inputFocus;
            inputblur = function (e) {
                if (!$(this).val()) {
                    $(this).parent('.form-group').removeClass('focused');
                }
            };
            inputFocus = function (e) {
                $(this).parents('.form-group').addClass('focused');
            };
            tmPk._document
                .on('blur', 'input,textarea,select', inputblur)
                .on('focus', 'input:not([type="radio"]),input:not([type="checkbox"]),textarea,select', inputFocus)

        },
        serviceWidget: function () {
            function serviceAnimation() {
                var $servicesWidget = $(".services-widget");
                var $activeBg = $servicesWidget.find(".active-bg");

                function updateActiveService($element) {
                    if (!$element.length) return;

                    var topOff = $element.position().top;
                    var height = $element.outerHeight(true); // include margins if needed

                    var $closestServiceItem = $element.closest(".service-item");
                    if ($closestServiceItem.length) {
                        $closestServiceItem.removeClass("mleave");
                    }

                    $servicesWidget.find(".service-item").each(function () {
                        var $item = $(this);
                        if (!$item.is($closestServiceItem)) {
                            $item.addClass("mleave");
                        }
                    });

                    $activeBg.css({
                        top: topOff + "px",
                        height: height + "px"
                    });
                }

                $servicesWidget.on("mouseenter", ".service-item", function () {
                    updateActiveService($(this));
                });

                $servicesWidget.on("mouseleave", function () {
                    var $currentElement = $servicesWidget.find(".current");
                    updateActiveService($currentElement);

                    $servicesWidget.find(".service-item").each(function () {
                        var $item = $(this);
                        if (!$item.is($currentElement.closest(".service-item"))) {
                            $item.removeClass("mleave");
                        }
                    });
                });

                setTimeout(function () {
                    updateActiveService($servicesWidget.find(".current"));
                }, 750);
            }

            serviceAnimation();
        }, wowActive: function () {
            new WOW().init();
        }, menuCurrentLink: function () {
            const currentPath = window.location.pathname.replace(/\/$/, "");
            $(".navbar-info.nav .nav-link").each(function () {
                const $link = $(this);
                const href = $link[0].pathname.replace(/\/$/, "");

                if (href === currentPath) {
                    $link.addClass("active");
                }
            });
        }, stickyHeader: function (e) {
            $(window).scroll(function () {
                if ($(this).scrollTop() > 150) {
                    $(".header--sticky").addClass("sticky");
                } else {
                    $(".header--sticky").removeClass("sticky");
                }
            });
        }, popupMobileMenu: function (e) {
            $(".humberger_menu_active").on("click", function (e) {
                $(".tmp-popup-mobile-menu").addClass("active");
            });

            $(".close-menu").on("click", function (e) {
                $(".tmp-popup-mobile-menu").removeClass("active");
                $(".tmp-popup-mobile-menu .tmp-mainmenu .has-dropdown > a")
                    .siblings(".submenu")
                    .removeClass("active")
                    .slideUp("400");
                $(".tmp-popup-mobile-menu .tmp-mainmenu .has-dropdown > a").removeClass("open");
            });

            $(".tmp-popup-mobile-menu .tmp-mainmenu .has-dropdown > a").on("click", function (e) {
                e.preventDefault();
                $(this).siblings(".submenu").toggleClass("active").slideToggle("400");
                $(this).toggleClass("open");
            });

            $(".tmp-popup-mobile-menu, .tmp-popup-mobile-menu .tmp-mainmenu.onepagenav li a").on("click", function (e) {
                e.target === this && $(".tmp-popup-mobile-menu").removeClass("active") && $(".tmp-popup-mobile-menu .tmp-mainmenu .has-dropdown > a")
                    .siblings(".submenu")
                    .removeClass("active")
                    .slideUp("400") && $(".tmp-popup-mobile-menu .tmp-mainmenu .has-dropdown > a").removeClass("open");
            });

            $(".onepagenav-click a").on("click", function (e) {
                $(".tmp-popup-mobile-menu").removeClass("active");
                tmPk._html.css({
                    overflow: "",
                });
            });
        }, mobileMenuActive: function (e) {
            $(".tmp_button_active").on("click", function (e) {
                e.preventDefault();
                $(".tmp_side_bar").addClass("tmp_side_bar_open");
                $("body").addClass("sidemenu-active");
                // tmPk._html.css({
                //   overflow: "hidden",
                // });
            });

            $(".close_side_menu_active").on("click", function (e) {
                e.preventDefault();
                $(".tmp_side_bar").removeClass("tmp_side_bar_open");
                $("body").removeClass("sidemenu-active");
                tmPk._html.css({
                    overflow: "",
                });
            });
        },
        adjustPageBottomPadding: function () {
            var $header = $(".header-area-bentogrid");
            var $page = $("#tmp-page-content-bento");
            var windowWidth = window.innerWidth;

            // Only run on screens smaller than Bootstrap's lg (992px)
            if (windowWidth < 992 && $header.length && $page.length) {
                var headerHeight = $header.outerHeight(true);
                var padding = headerHeight + 15;

                $page.css("padding-bottom", padding + "px");
            } else {
                // Reset padding for lg and up
                $page.css("padding-bottom", "");
            }
        },
        smoothScroll: function (e) {
            $(document).on("click", '.onepage a[href^="#"]', function (event) {
                event.preventDefault();
                $("html, body").animate({
                    scrollTop: $($.attr(this, "href")).offset().top,
                }, 2000);
            });
        }, rollingText: function () {
            let elements = document.querySelectorAll(".rolling-text");

            elements.forEach((element) => {
                let innerText = element.innerText;
                element.innerHTML = "";

                let textContainer = document.createElement("div");
                textContainer.classList.add("block");

                for (let letter of innerText) {
                    let span = document.createElement("span");
                    span.innerText = letter.trim() === "" ? "\xa0" : letter;
                    span.classList.add("letter");
                    textContainer.appendChild(span);
                }

                element.appendChild(textContainer);
                element.appendChild(textContainer.cloneNode(true));
            });

            elements.forEach((element) => {
                element.addEventListener("mouseover", () => {
                    element.classList.remove("play");
                });
            });
        }, radialProgress: function () {
            $("svg.radial-progress").each(function (index, value) {
                $(this).find($("circle.bar--animated")).removeAttr("style");
                // Get element in Veiw port
                var elementTop = $(this).offset().top;
                var elementBottom = elementTop + $(this).outerHeight();
                var viewportTop = $(window).scrollTop();
                var viewportBottom = viewportTop + $(window).height();

                if (elementBottom > viewportTop && elementTop < viewportBottom) {
                    var percent = $(value).data("countervalue");
                    var radius = $(this).find($("circle.bar--animated")).attr("r");
                    var circumference = 2 * Math.PI * radius;
                    var strokeDashOffset = circumference - (percent * circumference) / 100;
                    $(this)
                        .find($("circle.bar--animated"))
                        .animate({"stroke-dashoffset": strokeDashOffset}, 2800);
                }
            });
        }, tmpcustomAnimation: function () {
            return {
                init: function () {
                    this.animates();
                }, animates: function () {
                    var animates = $(".tmp-scroll-trigger");
                    if (animates.length > 0) {
                        animates.each(function () {
                            $(this).on("animationend", function (e) {
                                setTimeout(function () {
                                    $(e.target).attr("animation-end", "");
                                }, 1000);
                            });
                        });
                    }
                },
            };
        }, onePageNav: function () {
            $(".onepagenav").onePageNav({
                currentClass: "current",
                changeHash: false,
                scrollSpeed: 500,
                scrollThreshold: 0.2,
                filter: ":not(.external)",
                easing: "swing",
            });
        }, fonklsAnimation: function () {
            let endAnimation = document.getElementsByClassName('.end');
            if (endAnimation.length) {
                let endTl = gsap.timeline({
                    repeat: -1, delay: 0.2, scrollTrigger: {
                        trigger: ".end", start: "bottom 100%-=50px",
                    },
                });
                gsap.set(".end", {
                    opacity: 0,
                });
                gsap.to(".end", {
                    opacity: 1, duration: 1, ease: "power2.out", scrollTrigger: {
                        trigger: ".end", start: "bottom 100%-=50px", once: true,
                    },
                });
                let mySplitText = new SplitText(".end", {
                    type: "words,chars",
                });
                let chars = mySplitText.chars;
                endTl.to(chars, {
                    duration: 0.5, scaleY: 0.9, ease: "power3.out", stagger: 0.04, transformOrigin: "center bottom",
                });
                endTl.to(chars, {
                    yPercent: -10, ease: "elastic", stagger: 0.03, duration: 0.8,
                }, 0.5);
                endTl.to(chars, {
                    scaleY: 1, ease: "elastic.out(2.5, 0.2)", stagger: 0.03, duration: 1.5,
                }, 0.5);
                endTl.to(chars, {
                    ease: "power2.out", stagger: 0.03, duration: 0.3,
                }, 0.5);
                endTl.to(chars, {
                    yPercent: 0, ease: "back", stagger: 0.03, duration: 0.8,
                }, 0.7);
                endTl.to(chars, {
                    duration: 1.4, stagger: 0.05,
                });
            }

        }, stickyToTop: function (e) {
            $(".tmp-sticky-top").css({
                top: 25,
            });
            $(".tmp-sticky-top-2").css({
                top: 80,
            });
        }, preloaderWithBannerActivation: function () {
            document.addEventListener("DOMContentLoaded", function () {
                // Select all title and subtitle elements
                const heroTitles = document.querySelectorAll(".tmp-title-split");
                const heroSubtitles = document.querySelectorAll(".hero__sub-title");

                // Loop through each pair of title and subtitle
                heroTitles.forEach((title, index) => {
                    const subtitle = heroSubtitles[index]; // Match title with subtitle (if in pairs)

                    // Split the text for both title and subtitle
                    const splitTitle = new SplitText(title, {type: "chars"});
                    const splitSubtitle = subtitle ? new SplitText(subtitle, {type: "chars words"}) : null;

                    // Create a timeline for each title and subtitle
                    gsap.timeline({
                        scrollTrigger: {
                            trigger: title, // Trigger animation when the current title comes into view
                            start: "top 80%", // Start when the top of the element reaches 80% of the viewport height
                            end: "bottom 60%", // Optional: Define when animation ends
                            toggleActions: "play none none none", // Play only once
                            // markers: true // Uncomment for debugging
                        },
                    })
                        .from(splitTitle.chars, {
                            duration: 0.2, x: -10, autoAlpha: .02, stagger: 0.02,
                        })
                        .from(splitSubtitle ? splitSubtitle.words : [], {
                                duration: 0.8, x: 100, autoAlpha: 0, stagger: 0.01,
                            }, "-=1" // Overlap with the previous animation
                        );
                });
            });
            document.addEventListener("DOMContentLoaded", function () {
                // Select all title and subtitle elements
                const heroTitles = document.querySelectorAll(".tmp-title-split-2");
                const heroSubtitles = document.querySelectorAll(".hero__sub-title");

                // Loop through each pair of title and subtitle
                heroTitles.forEach((title, index) => {
                    const subtitle = heroSubtitles[index]; // Match title with subtitle (if in pairs)

                    // Split the text for both title and subtitle
                    const splitTitle = new SplitText(title, {type: "chars"});
                    const splitSubtitle = subtitle ? new SplitText(subtitle, {type: "chars words"}) : null;

                    // Create a timeline for each title and subtitle
                    gsap.timeline({
                        scrollTrigger: {
                            trigger: title, // Trigger animation when the current title comes into view
                            start: "top 80%", // Start when the top of the element reaches 80% of the viewport height
                            end: "bottom 60%", // Optional: Define when animation ends
                            toggleActions: "play none none none", // Play only once
                            // markers: true // Uncomment for debugging
                        },
                    })
                        .from(splitTitle.chars, {
                            duration: 0.2, x: -10, autoAlpha: .06, stagger: 0.01,
                        })
                        .from(splitSubtitle ? splitSubtitle.words : [], {
                                duration: 0.2, x: 100, autoAlpha: .06, stagger: 0.01,
                            }, "-=1" // Overlap with the previous animation
                        );
                });
            });
        }, titleSplit_2: function () {
            if ($('.tmp-title-split').length) {
                let staggerAmount = 0.03, translateXValue = 20, delayValue = 0.1, easeType = "power2.out",
                    animatedTextElements = document.querySelectorAll('.tmp-title-split');

                animatedTextElements.forEach((element) => {
                    let animationSplitText = new SplitText(element, {type: "chars, words"});
                    gsap.from(animationSplitText.chars, {
                        duration: 1,
                        delay: delayValue,
                        x: translateXValue,
                        autoAlpha: 0,
                        stagger: staggerAmount,
                        ease: easeType,
                        scrollTrigger: {trigger: element, start: "top 85%"},
                    });
                });
            }
        }, tiltAnimation: function () {

            let tiltAnimation = document.getElementsByClassName('tilt-container');

            if (tiltAnimation.length) {
                $(document).ready(function () {
                    let tiltContainer = document.querySelector('.tilt-container');

                    if (tiltContainer) {
                        tiltContainer.addEventListener('mousemove', (e) => {
                            const xPos = (window.innerWidth / 2 - e.pageX) / 80;
                            const yPos = (window.innerHeight / 2 - e.pageY) / 80;

                            tiltContainer.style.transform = `rotateX(${yPos}deg) rotateY(${xPos}deg)`;
                        });

                        tiltContainer.addEventListener('mouseenter', () => {
                            tiltContainer.style.transition = 'none';
                        });

                        tiltContainer.addEventListener('mouseleave', () => {
                            tiltContainer.style.transition = 'transform 0.3s';
                            tiltContainer.style.transform = 'none';
                        });
                    }
                });
            }

        },

        lineAnimation: function () {
            let line_animation = document.querySelectorAll('.for-animation-inner');
            if (line_animation.length) {
                const parent = document.querySelector('.for-animation-inner');
                const line1 = document.querySelector('.cta__line-1');
                const line2 = document.querySelector('.cta__line-2');

                function animateLines() {
                    const parentHeight = parent.offsetWidth;

                    // Animating the first line using Timeline
                    gsap.killTweensOf(line1);
                    gsap.set(line1, {x: 0, opacity: 0});
                    const tl1 = gsap.timeline({
                        repeat: -1, onRepeat: () => gsap.set(line1, {x: 0, opacity: 0}),
                    });
                    tl1
                        .to(line1, {duration: 0.3, opacity: 1})
                        .to(line1, {duration: 4, x: parentHeight, ease: 'none'}, '<')
                        .to(line1, {duration: 0.3, opacity: 0}, 3);

                    // Animating the Second Line Using Timeline
                    gsap.killTweensOf(line2);
                    gsap.set(line2, {x: 0, opacity: 0});
                    const tl2 = gsap.timeline({
                        repeat: -1, onRepeat: () => gsap.set(line2, {x: 0, opacity: 0}),
                    });
                    tl2
                        .to(line2, {duration: 0.3, opacity: 1})
                        .to(line2, {duration: 4, x: -parentHeight, ease: 'none'}, '<')
                        .to(line2, {duration: 0.3, opacity: 0}, 3);
                }

                animateLines();
            }
        }, initTooltips: function (e) {
            const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
            const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
        }, initSwiper: function (e) {
            if ($('.profitabilitySwiper').length) {
                new Swiper(".profitabilitySwiper", {
                    slidesPerView: 2, spaceBetween: 30, loop: true, autoplay: {
                        delay: 1500, disableOnInteraction: true,
                    }, pagination: {
                        el: ".profitability-pagination", dynamicBullets: true, clickable: true,
                    }, breakpoints: {
                        576: {
                            slidesPerView: 3
                        }, 992: {
                            slidesPerView: 4
                        }, 1400: {
                            slidesPerView: 5
                        },
                    }
                });
            }
        }, stickyFaqObserver: function () {
            var cards = document.querySelectorAll('.resume-single-list');

            function onScroll() {
                cards.forEach(function (card, index) {
                    var nextCard = cards[index + 1];

                    // Always reset to visible
                    card.classList.remove('hidden');

                    if (nextCard) {
                        var cardRect = card.getBoundingClientRect();
                        var nextRect = nextCard.getBoundingClientRect();
                        var overlap = (cardRect.bottom) - (nextRect.top);
                        var totalHeight = cardRect.height;
                        if (overlap > totalHeight * 0.55) {
                            card.classList.add('hidden');
                        }
                    }
                });
            }

            window.addEventListener('scroll', onScroll);
            window.addEventListener('resize', onScroll);
            onScroll();
        },
        marqueeAnimation: function (e) {
            const wrapper = document.querySelector('.marquee-wrapper');
            const track = wrapper?.querySelector('.marquee-track');
            const content = wrapper?.querySelector('.marquee-content:not(.clone)');
            const clone = wrapper?.querySelector('.marquee-content.clone');

            if (!wrapper || !track || !content || !clone) return;

            // Clone the content exactly
            clone.innerHTML = content.innerHTML;

            requestAnimationFrame(() => {
                const contentWidth = content.offsetWidth;
                const totalWidth = contentWidth * 2;

                const isRTL = document.documentElement.dir === 'rtl';
                const animationName = `scroll-marquee-${Date.now()}`;
                const direction = isRTL ? contentWidth : -contentWidth;

                const style = document.createElement('style');
                style.innerHTML = `
                    @keyframes ${animationName} {
                      0% { transform: translateX(0); }
                      100% { transform: translateX(${direction}px); }
                    }
                  `;
                document.head.appendChild(style);

                const speed = totalWidth / 300;
                track.style.animation = `${animationName} ${speed}s linear infinite`;
            });
        },
        youtubePopup: function (e) {
            $('.yt').magnificPopup({
                type: 'iframe',
                removalDelay: 160,
            });
        },
    };

    tmPk.m();
})(jQuery, window);


// Back To Top style here
function updateDimensions() {
    windowHeight = window.innerHeight;
    documentHeight = document.documentElement.scrollHeight - windowHeight;
}

// Initialize dimensions
updateDimensions();

// Add resize event listener to update dimensions
window.addEventListener('resize', updateDimensions);

document.addEventListener('DOMContentLoaded', function () {
    var box = document.querySelector(".scrollToTop");
    if (box) {
        var water = box.querySelector(".water");

        window.addEventListener('scroll', function () {
            var scrollPosition = window.scrollY;
            var percent = Math.min(Math.floor((scrollPosition / documentHeight) * 100), 100);
            water.style.transform = "translate(0," + (100 - percent) + "%)";

            if (scrollPosition >= 200) {
                box.style.display = 'block';
            } else {
                box.style.display = 'none';
            }
        });

        // Add click event listener to scroll to top
        box.onclick = function () {
            window.scrollTo({
                top: 0, behavior: "smooth"
            });
        };
    }

    // Preloader functionality
    function removePreloader() {
        document.body.classList.remove("preloader-active");
    }

    document.body.classList.add("preloader-active");
    window.addEventListener('load', function () {
        removePreloader();
    });

    function playVideo() {
        $('#main-video').trigger('play');
    }

    function pauseVideo() {
        $('#main-video').trigger('pause');
    }

    document.addEventListener("visibilitychange", function () {
        if (document.visibilityState === 'visible') {
            playVideo();
        } else {
            pauseVideo();
        }
    });
});


